/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class PanelCellNeighbor {
    private IPanelCell iPanelCell = null;
    private BlockPos blockPos = null;
    private final Side neighborDirection;
    private Side neighborsSide = null;
    private final PanelTile panelTile;
    private PanelCellPos cellPos;
    private BlockState blockState;

    PanelCellNeighbor(PanelCellPos cellPos, IPanelCell panelCell, Side neighborsSide, Side neighborDirection) {
        this.iPanelCell = panelCell;
        this.panelTile = cellPos.getPanelTile();
        this.neighborsSide = neighborsSide;
        this.cellPos = cellPos;
        this.neighborDirection = neighborDirection;
    }

    PanelCellNeighbor(PanelTile panelTile, BlockPos blockPos, Side neighborDirection) {
        this.blockPos = blockPos;
        this.panelTile = panelTile;
        this.neighborDirection = neighborDirection;
    }

    public int getWeakRsOutput() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.getWeakRsOutput(this.neighborsSide);
        }
        if (this.blockPos != null) {
            return this.panelTile.m_58904_().m_277185_(this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return 0;
    }

    public int getStrongRsOutput() {
        if (this.iPanelCell != null && !(this.iPanelCell instanceof TinyBlock)) {
            return this.iPanelCell.getStrongRsOutput(this.neighborsSide);
        }
        if (this.blockPos != null) {
            return this.panelTile.m_58904_().m_277075_(this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return 0;
    }

    public int getStrongRsOutputForWire() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.getStrongRsOutput(this.neighborsSide);
        }
        if (this.blockPos != null) {
            int signal = this.getStrongRsOutput();
            if (signal < 15 && PanelCellNeighbor.blockIsRedstoneWire(this.getNeighborBlockState().m_60734_(), false)) {
                signal = this.getWeakRsOutput();
            }
            if (signal < 15 && this.getNeighborBlockState().m_60796_((BlockGetter)this.panelTile.m_58904_(), this.blockPos)) {
                PanelTile.checkWireSignals = false;
                for (Direction direction : new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                    BlockPos neighborNeighborPos = this.blockPos.m_121945_(direction);
                    BlockState neighborNeighborState = this.panelTile.m_58904_().m_8055_(neighborNeighborPos);
                    Block neighborNeighborBlock = neighborNeighborState.m_60734_();
                    if (neighborNeighborBlock != Blocks.f_50088_) {
                        signal = Math.max(signal, this.panelTile.m_58904_().m_277075_(neighborNeighborPos, direction));
                    }
                    if (signal < 15) continue;
                    return signal;
                }
                PanelTile.checkWireSignals = true;
            }
            return signal;
        }
        return 0;
    }

    public boolean hasComparatorOverride() {
        if (this.blockPos != null) {
            return this.getNeighborBlockState().m_60807_();
        }
        return false;
    }

    public int getComparatorOverride() {
        if (this.blockPos != null && this.hasComparatorOverride()) {
            return this.getNeighborBlockState().m_60674_(this.panelTile.m_58904_(), this.blockPos);
        }
        return 0;
    }

    public boolean powerDrops() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.powerDrops();
        }
        if (this.blockPos != null) {
            return PanelCellNeighbor.blockIsRedstoneWire(this.getNeighborBlockState().m_60734_());
        }
        return false;
    }

    public boolean isPushable() {
        return this.panelTile.canExtendTo(this.cellPos, this.neighborDirection, 0);
    }

    public boolean isOnPanel() {
        return this.cellPos != null;
    }

    public boolean canConnectRedstone() {
        BlockState blockState = this.getNeighborBlockState();
        if (blockState != null && !PanelCellNeighbor.blockIsRedstoneWire(this.getNeighborBlockState().m_60734_(), false)) {
            return blockState.canRedstoneConnectTo((BlockGetter)this.panelTile.m_58904_(), this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return this.iPanelCell != null && !(this.iPanelCell instanceof TinyBlock) && !this.iPanelCell.powerDrops();
    }

    public IPanelCell getNeighborIPanelCell() {
        return this.iPanelCell;
    }

    public BlockState getNeighborBlockState() {
        if (this.blockPos != null) {
            if (this.blockState == null) {
                this.blockState = this.panelTile.m_58904_().m_8055_(this.blockPos);
            }
            return this.blockState;
        }
        return null;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public PanelCellPos getCellPos() {
        return this.cellPos;
    }

    public Side getNeighborsSide() {
        return this.neighborsSide;
    }

    public static boolean blockIsRedstoneWire(Block block) {
        return PanelCellNeighbor.blockIsRedstoneWire(block, true);
    }

    public static boolean blockIsRedstoneWire(Block block, boolean includeVanilla) {
        if (includeVanilla && block == Blocks.f_50088_) {
            return true;
        }
        return ((List)Config.REDSTONE_WIRE_LIST.get()).contains(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
    }
}

